/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.world.feature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEndPortal;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import svenhjol.charm.world.block.BlockRunePortal;
import svenhjol.charm.world.block.BlockRunePortalFrame;
import svenhjol.charm.world.compat.QuarkColoredRunes;
import svenhjol.charm.world.event.WitherDestroyBlockEvent;
import svenhjol.charm.world.message.MessagePortalInteract;
import svenhjol.charm.world.storage.RunePortalSavedData;
import svenhjol.charm.world.tile.TileRunePortalFrame;
import svenhjol.meson.Feature;
import svenhjol.meson.Meson;
import svenhjol.meson.MesonBlock;
import svenhjol.meson.handler.NetworkHandler;
import svenhjol.meson.helper.ForgeHelper;
import svenhjol.meson.helper.PlayerHelper;
import svenhjol.meson.helper.SoundHelper;
import svenhjol.meson.helper.WorldHelper;

public class EndPortalRunes
extends Feature {
    public static BlockRunePortalFrame frame;
    public static BlockRunePortal portal;
    public static QuarkColoredRunes quarkRunes;
    public static boolean allowEnderEyeRemoval;
    public static long clientTravelTicks;
    public static long clientUnlinkedTicks;
    public static long clientLinkedTicks;

    @Override
    public String getDescription() {
        return "Add Colored Runes in Stronghold End Portal frames. Two portals with the same runes will be linked together.";
    }

    @Override
    public void configure() {
        super.configure();
        allowEnderEyeRemoval = this.propBoolean("Allow Eyes of Ender removal", "Eyes of Ender can be removed from End Portal frames by right-clicking when sneaking.\nIf false, right-clicking with a rune replaces the Eye of Ender without returning it to the player.", true);
    }

    @Override
    public boolean isEnabled() {
        if (!ForgeHelper.areModsLoaded("quark")) {
            return false;
        }
        try {
            quarkRunes = (QuarkColoredRunes)QuarkColoredRunes.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            Meson.log("Error loading QuarkColoredRunes compat class");
            return false;
        }
        if (!quarkRunes.hasColorRuneFeature()) {
            Meson.log("Quark ColorRunes feature not enabled");
            return false;
        }
        return this.enabled;
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        portal = new BlockRunePortal();
        frame = new BlockRunePortalFrame();
        GameRegistry.registerTileEntity(portal.getTileEntityClass(), (ResourceLocation)new ResourceLocation("charm:rune_portal"));
        GameRegistry.registerTileEntity(frame.getTileEntityClass(), (ResourceLocation)new ResourceLocation("charm:rune_portal_frame"));
        NetworkHandler.register(MessagePortalInteract.class, Side.CLIENT);
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        RunePortalSavedData.get(world);
    }

    @SubscribeEvent
    public void onWitherDestroyBlock(WitherDestroyBlockEvent event) {
        Block block = event.getBlock();
        if (block == portal || block == frame) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        boolean isModdedFrame;
        IBlockState current = event.getWorld().func_180495_p(event.getPos());
        boolean isVanillaFrame = current.func_177230_c() == Blocks.field_150378_br;
        boolean bl = isModdedFrame = current.func_177230_c() == frame;
        if (isVanillaFrame || isModdedFrame) {
            World world = event.getWorld();
            BlockPos pos = event.getPos();
            ItemStack held = event.getEntityPlayer().func_184586_b(event.getHand());
            ItemStack drop = null;
            EntityPlayer player = event.getEntityPlayer();
            IBlockState changed = null;
            current = current.func_185899_b((IBlockAccess)event.getWorld(), event.getPos());
            if (quarkRunes.isRune(held) && !player.func_70093_af()) {
                if (isVanillaFrame && ((Boolean)current.func_177229_b((IProperty)BlockEndPortalFrame.field_176507_b)).booleanValue() && allowEnderEyeRemoval) {
                    drop = new ItemStack(Items.field_151061_bv, 1);
                    changed = Blocks.field_150378_br.func_176223_P().func_177226_a((IProperty)BlockEndPortalFrame.field_176508_a, current.func_177229_b((IProperty)BlockRunePortalFrame.FACING));
                    EndPortalRunes.deactivate(world, pos);
                }
                if (isModdedFrame) {
                    drop = quarkRunes.getRuneFromMeta(((MesonBlock.ColorVariant)((Object)current.func_177229_b(BlockRunePortalFrame.VARIANT))).ordinal());
                }
                EndPortalRunes.addRune(world, pos, held);
                EndPortalRunes.activate(world, pos);
            } else if (player.func_70093_af()) {
                if (isVanillaFrame && !world.field_72995_K && ((Boolean)current.func_177229_b((IProperty)BlockEndPortalFrame.field_176507_b)).booleanValue() && allowEnderEyeRemoval) {
                    drop = new ItemStack(Items.field_151061_bv, 1);
                }
                if (isModdedFrame) {
                    drop = quarkRunes.getRuneFromMeta(((MesonBlock.ColorVariant)((Object)current.func_177229_b(BlockRunePortalFrame.VARIANT))).ordinal());
                }
                if (drop != null) {
                    EnumFacing frameFacing = (EnumFacing)current.func_177229_b((IProperty)BlockEndPortalFrame.field_176508_a);
                    changed = Blocks.field_150378_br.func_176223_P().func_177226_a((IProperty)BlockEndPortalFrame.field_176508_a, (Comparable)frameFacing);
                }
                EndPortalRunes.deactivate(world, pos);
                if (drop != null) {
                    event.setCanceled(true);
                }
            }
            if (changed != null) {
                world.func_180501_a(pos, changed, 3);
            }
            if (drop != null) {
                PlayerHelper.addOrDropStack(player, drop);
            }
        }
    }

    public static void addRune(World world, BlockPos pos, ItemStack rune) {
        IBlockState current = world.func_180495_p(pos);
        EnumFacing currentFacing = (EnumFacing)current.func_177229_b((IProperty)BlockRunePortalFrame.FACING);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileRunePortalFrame) {
            currentFacing = ((TileRunePortalFrame)tile).getFacing();
        }
        IBlockState changed = frame.func_176223_P().func_177226_a(BlockRunePortalFrame.VARIANT, (Comparable)((Object)quarkRunes.getRuneColor(rune))).func_177226_a((IProperty)BlockRunePortalFrame.FACING, (Comparable)currentFacing);
        world.func_180501_a(pos, changed, 2);
        tile = world.func_175625_s(pos);
        if (tile instanceof TileRunePortalFrame) {
            ((TileRunePortalFrame)tile).setFacing(currentFacing);
        }
        world.func_180501_a(pos, changed, 2);
        if (world.field_72995_K) {
            SoundHelper.playSoundAtPos(world, pos, SoundEvents.field_193781_bp, 1.0f, 1.0f);
        }
        rune.func_190918_g(1);
    }

    public static void activate(World world, BlockPos pos) {
        HashMap orderMap = new HashMap();
        BlockPattern.PatternHelper pattern = BlockRunePortalFrame.getOrCreatePortalShape().func_177681_a(world, pos);
        if (pattern != null) {
            BlockPos patternStart = pattern.func_181117_a().func_177982_a(-5, 0, -5);
            for (int a = 0; a < 6; ++a) {
                for (int b = 0; b < 6; ++b) {
                    IBlockState state = world.func_180495_p(patternStart.func_177982_a(a, 0, b));
                    if (state.func_177230_c() != frame) continue;
                    int face = ((EnumFacing)state.func_177229_b((IProperty)BlockRunePortalFrame.FACING)).func_176745_a();
                    if (!orderMap.containsKey(face)) {
                        orderMap.put(face, new ArrayList());
                    }
                    ((List)orderMap.get(face)).add(frame.func_176201_c(state));
                }
            }
            BlockPos thisPortal = pattern.func_181117_a();
            RunePortalSavedData data = RunePortalSavedData.get(world);
            if (data != null) {
                ArrayList order = new ArrayList();
                for (int i2 : new int[]{2, 4, 3, 5}) {
                    List row = (List)orderMap.get(i2);
                    Collections.sort(row);
                    order.addAll(row);
                }
                data.portals.put(thisPortal, order.stream().mapToInt(i -> i).toArray());
                EndPortalRunes.removeCachedPortal(world, thisPortal);
            }
            if (EndPortalRunes.findPortal(world, thisPortal) != null && !world.field_72995_K) {
                NetworkHandler.INSTANCE.sendToAll((IMessage)new MessagePortalInteract(thisPortal, 1));
            }
            BlockPos start = thisPortal.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = start.func_177982_a(j, 0, k);
                    world.func_180501_a(p, portal.func_176223_P(), 2);
                    portal.setPortal(world, p, thisPortal);
                }
            }
        }
    }

    public static void deactivate(World world, BlockPos pos) {
        BlockPos thisPortal = null;
        BlockPattern.PatternHelper pattern = BlockRunePortalFrame.getOrCreatePortalShape().func_177681_a(world, pos);
        if (pattern == null) {
            BlockPos pos1 = pos.func_177982_a(-3, 0, -3);
            BlockPos pos2 = pos.func_177982_a(3, 0, 3);
            Iterable box = BlockPos.func_177980_a((BlockPos)pos1, (BlockPos)pos2);
            for (BlockPos inBox : box) {
                if (!(world.func_180495_p(inBox).func_177230_c() instanceof BlockEndPortal)) continue;
                if (thisPortal == null) {
                    thisPortal = portal.getPortal(world, inBox);
                }
                world.func_175698_g(inBox);
            }
            if (thisPortal != null) {
                RunePortalSavedData data = RunePortalSavedData.get(world);
                if (data != null) {
                    data.portals.remove(thisPortal);
                    EndPortalRunes.removeCachedPortal(world, thisPortal);
                }
                if (!world.field_72995_K) {
                    NetworkHandler.INSTANCE.sendToAll((IMessage)new MessagePortalInteract(thisPortal, 0));
                }
            }
        }
    }

    public static BlockPos findPortal(World world, BlockPos thisPortal) {
        RunePortalSavedData data = RunePortalSavedData.get(world);
        BlockPos foundPortal = null;
        ArrayList<BlockPos> matching = new ArrayList<BlockPos>();
        if (data != null && data.portals.containsKey(thisPortal)) {
            BlockPos linkedPortal = data.links.get(thisPortal);
            if (linkedPortal != null) {
                if (data.portals.containsKey(linkedPortal)) {
                    Meson.debug("EndPortalRunes: [CACHE] found portal", linkedPortal);
                    return linkedPortal;
                }
                Meson.debug("EndPortalRunes: [CACHE] cleaning unlinked portal", linkedPortal);
                data.links.remove(thisPortal);
            }
            List o1 = Arrays.stream(data.portals.get(thisPortal)).boxed().collect(Collectors.toList());
            for (BlockPos portalPos : data.portals.keySet()) {
                boolean matched;
                if (portalPos.func_177986_g() == thisPortal.func_177986_g()) continue;
                List o2 = Arrays.stream(data.portals.get(portalPos)).boxed().collect(Collectors.toList());
                int w = 0;
                do {
                    Collections.rotate(o2, 1);
                } while (!(matched = o1.equals(o2)) && ++w < 12);
                if (!matched) continue;
                matching.add(portalPos);
            }
        }
        if (matching.isEmpty()) {
            return null;
        }
        double dist = 0.0;
        for (BlockPos matchedPortal : matching) {
            double d = WorldHelper.getDistanceSq(thisPortal, matchedPortal);
            if (dist != 0.0 && !(d < dist)) continue;
            foundPortal = matchedPortal;
            dist = d;
        }
        Meson.debug("EndPortalRunes: found matching portal, caching it", foundPortal);
        data.links.put(thisPortal, foundPortal);
        data.links.put(foundPortal, thisPortal);
        return foundPortal;
    }

    public static void removeCachedPortal(World world, BlockPos portal) {
        RunePortalSavedData data = RunePortalSavedData.get(world);
        if (data != null) {
            BlockPos cachedPortal = data.links.get(portal);
            if (cachedPortal != null) {
                data.links.remove(cachedPortal);
            }
            data.links.clear();
            data.func_76185_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void effectPortalLinked(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        long time = world.func_72820_D();
        if (clientLinkedTicks == 0L || time - clientLinkedTicks > 20L) {
            BlockPos current = pos.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = current.func_177982_a(j, 0, k);
                    for (int i = 0; i < 12; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.1;
                        double d1 = world.field_73012_v.nextGaussian() * 0.1;
                        double d2 = world.field_73012_v.nextGaussian() * 0.1;
                        double dx = (float)p.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        double dy = (float)p.func_177956_o() + 1.1f;
                        double dz = (float)p.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        world.func_175688_a(EnumParticleTypes.PORTAL, dx, dy, dz, d0, d1, d2, new int[0]);
                    }
                }
            }
            SoundHelper.playSoundAtPos((World)world, pos, SoundEvents.field_187814_ei, 0.8f, 1.45f);
            clientLinkedTicks = time;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void effectPortalUnlinked(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        long time = world.func_72820_D();
        if (clientUnlinkedTicks == 0L || time - clientUnlinkedTicks > 20L) {
            BlockPos current = pos.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = current.func_177982_a(j, 0, k);
                    for (int i = 0; i < 16; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.02;
                        double d1 = world.field_73012_v.nextGaussian() * 0.02;
                        double d2 = world.field_73012_v.nextGaussian() * 0.02;
                        double dx = (float)p.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        double dy = (float)p.func_177956_o() + 0.5f;
                        double dz = (float)p.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, dx, dy, dz, d0, d1, d2, new int[0]);
                    }
                }
            }
            SoundHelper.playSoundAtPos((World)world, pos, SoundEvents.field_187541_bC, 0.75f, 0.7f);
            clientUnlinkedTicks = time;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void effectPortalTravelled(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        long time = world.func_72820_D();
        if (clientTravelTicks == 0L || time - clientTravelTicks > 20L) {
            BlockPos current = pos.func_177982_a(-3, 0, -3);
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    BlockPos p = current.func_177982_a(j, 0, k);
                    for (int i = 0; i < 6; ++i) {
                        double d0 = world.field_73012_v.nextGaussian() * 0.1;
                        double d1 = world.field_73012_v.nextGaussian() * 0.1;
                        double d2 = world.field_73012_v.nextGaussian() * 0.1;
                        double dx = (float)p.func_177958_n() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        double dy = (float)p.func_177956_o() + 0.8f;
                        double dz = (float)p.func_177952_p() + MathHelper.func_76131_a((float)world.field_73012_v.nextFloat(), (float)0.25f, (float)0.75f);
                        world.func_175688_a(EnumParticleTypes.CLOUD, dx, dy, dz, d0, d1, d2, new int[0]);
                    }
                }
            }
            SoundHelper.playSoundAtPos((World)world, pos, SoundEvents.field_187812_eh, 0.75f, 1.0f);
            clientTravelTicks = time;
        }
    }

    @Override
    public boolean hasSubscriptions() {
        return true;
    }
}

